function fault_slip_plot_diag_eigen(a,A,colors,delta_c,delta_j,delta_top,Delta_y,E,...
    flag_plot_cap,mu_dyn,mu_st,N,N_0,N_2,sigma_j,T,U,U_1,U_2,ww,y_j,y_plot_max,...
    y_plot_min,y_tilde,y_top,z_j)
%
% Plots diagnostics to check slip-weakening friction computation for eigenvalue analysis.  
%

% Retrieve colors:
blue = colors(1,:);

% Compute friction: 
mu_help = mu_st - (mu_st-mu_dyn)*(abs(delta_j)/delta_c);
mu = min(max(mu_help,mu_dyn),mu_st);

% Plot various quantities:
figure
subplot(1,5,1) % sigma_norm_eff_comb from fault_slip_sigma.m, interpolated at Chebyshev points
x_plot_min = min(sigma_j/1e6);
x_plot_max = max(sigma_j/1e6);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(sigma_j/1e6,y_j,'-','Color','r','LineWidth',1.5) 
% plot(sigma_j/1e6,y_j,'o','LineWidth',1.5,'Color','r','MarkerSize',3,'MarkerEdgeColor',...
%     'red','MarkerFaceColor','white')
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('${\Sigma\prime}_{\perp}$ (MPa)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
if flag_plot_cap == 1
    [t,s] = title('plot\_diag\_eigen',' '); % first line: plot file locator
    t.Color = 'r';
    t.FontSize = 10;
    s.FontSize = 10;
    t.FontWeight = 'normal';
    s.FontWeight = 'normal';
end

subplot(1,5,2)
ddelta_dy_top_num = diff(delta_top)./diff(y_top); % numerical derivative
y_top_num = (y_top(1:end-1)+y_top(2:end))/2;
x_plot_min = min(ddelta_dy_top_num/1e-3);
x_plot_max = max(ddelta_dy_top_num/1e-3);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([0,0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
plot(ddelta_dy_top_num/1e-3,y_top_num,'-r','LineWidth',1.5) 
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\nabla\delta$ (mm/m)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

subplot(1,5,3)
x_plot_min = min(delta_top/1e-3);
x_plot_max = max(delta_top/1e-3);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(delta_top/1e-3,y_top,'-r','LineWidth',1.5) % directly from simulation
% plot(delta_j/1e-3,y_j,'--b','LineWidth',1.5) % interpolated at Chebyshev points
% plot(delta_j/1e-3,y_j,'o','LineWidth',1.5,'Color','r','MarkerSize',3,'MarkerEdgeColor',...
%     'red','MarkerFaceColor','white')
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\delta$ (mm)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

subplot(1,5,4)
x_plot_min = 0.15;
% % % x_plot_min = 0.45;
x_plot_max = 0.55;
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([mu_dyn, mu_dyn],[y_plot_min y_plot_max],'LineStyle','--','Color','k','LineWidth',0.5)
line([mu_st, mu_st],[y_plot_min y_plot_max],'LineStyle','--','Color','k','LineWidth',0.5)
plot(mu,y_j,'-r','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\rm \mu$ (-)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

subplot(1,5,5)
x_plot_min = min(ww/1e9);
x_plot_max = max(ww/1e9);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(ww/1e9,y_j,'-r','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\it w$ (MPa/mm)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

fprintf('Minimum friction value reached = %5.2f. \r\r', min(mu));          

% Plot induced stress rate and slip rate:
sigma_breve = T*E; % induced stress rate Pa/Pa
% % zz = -sqrt(1-z_j.^2)/(pi*A); % 1 x N vector
% % Z = diag(zz); % N x N diagonal matrix
% % d_delta_dp = (Delta_y/2)*Z*(U*N_0-U_2*N_2)*E; % induced slip rate, m/Pa
zz = sqrt(1-z_j.^2)/(pi*A); % 1 x N vector
Z = diag(zz); % N x N diagonal matrix
a_tilde = -( (acos(z_j) - pi - z_j.*sqrt(1-z_j.^2))/(2*pi*A) )'; % N x 1 vector  
AA_tilde = [zeros(N,1),a_tilde,zeros(N,N-2)]; 
d_delta_dp = (Delta_y/2)*( AA_tilde + Z*(U*N_0-U_2*N_2) )*E; 
d2delta_dy_dp = Z*U_1*E; % induced slip gradient rate, 1/Pa
% % d2delta_dy_dp = [(d_delta_dp(2:end)-d_delta_dp(1:end-1))./(y_j(2:end)-y_j(1:end-1))';0];

figure
subplot(1,3,1)
x_plot_max_abs = max(abs(sigma_breve)); 
x_plot_min = min(sigma_breve)/x_plot_max_abs;
x_plot_max = max(sigma_breve)/x_plot_max_abs;
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(sigma_breve/x_plot_max_abs,y_j,'LineStyle','-','Color',blue,'LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\dot{\breve\sigma}^*_{\parallel}$','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
if flag_plot_cap == 1
    % t = title('Eigenvector');
    % t.FontSize = 10;
    % t.FontWeight = 'normal';
    [t,s] = title('plot\_diag\_eigen','Eigenvector'); % first line: plot file locator
    t.Color = 'r';
    t.FontSize = 10;
    s.FontSize = 10;
    t.FontWeight = 'normal';
    s.FontWeight = 'normal';
end

subplot(1,3,2)
x_plot_max_abs = max(abs(d2delta_dy_dp)); 
x_plot_min = min(d2delta_dy_dp)/x_plot_max_abs;
x_plot_max = max(d2delta_dy_dp)/x_plot_max_abs;
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(d2delta_dy_dp/x_plot_max_abs,y_j,'LineStyle','-','Color',blue,'LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('${\nabla \dot\delta}^*$','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
if flag_plot_cap == 1
    t = title('Eigenvector');
    t.FontSize = 10;
    t.FontWeight = 'normal';
end

subplot(1,3,3)
x_plot_max_abs = max(abs(d_delta_dp)); 
x_plot_min = min(d_delta_dp)/x_plot_max_abs;
x_plot_max = max(d_delta_dp)/x_plot_max_abs;
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(d_delta_dp/x_plot_max_abs,y_j,'LineStyle','-','Color',blue,'LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\dot\delta^*$','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
if flag_plot_cap == 1
    t = title('Eigenvector');
    t.FontSize = 10;
    t.FontWeight = 'normal';
end


